--guid, to make sure no one else uses this same identifier (ffs, don't copy paste this line if you make your own scripts)
if scriptGUID_171AF2BAA45D11E19DE29B1B6288709B==true then return end
scriptGUID_171AF2BAA45D11E19DE29B1B6288709B=true



function replacePointers32(copybase, originalbase, size)
  local i=0
  while i<size do
    local oldValue=readInteger(copybase+i)
    if (oldValue>=originalbase) and (oldValue<originalbase+size) then
      writeInteger(copybase+i, copybase+(oldValue-originalbase))
    end
    i=i+4     
  end
end

function replacePointers64(copybase, originalbase, size)
  local i=0
  while i<size do
    local oldValue=readQword(copybase+i)
    if (oldValue>=originalbase) and (oldValue<originalbase+size) then
      writeQword(copybase+i, copybase+(oldValue-originalbase))
    end
    i=i+8    
  end
end

function stackcopyfix(sender)
  local copybase=0
  local originalbase=0
  local size=0

  local mv=getMemoryViewForm()
  local hv=memoryview_getHexadecimalView(mv)
  copybase=hexadecimalview_getTopAddress(hv)

  control_setCaption(frmFixStack_edtCopy, string.format('%x', copybase))
  edit_clear(frmFixStack_edtOriginal)
  control_setCaption(frmFixStack_edtSize, '4096')

  result=form_showModal(frmFixStack)
  
  if (result~=mrCancel) then
    if targetIs64Bit() then
      replacePointers64(copybase, originalbase, size)
    else
      replacePointers32(copybase, originalbase, size)
    end
  end

end

mv=getMemoryViewForm()
hv=memoryview_getHexadecimalView(mv)
pm=control_getPopupMenu(hv)
pmi=menu_getItems(pm)

mi=createMenuItem(pmi)
menuItem_setCaption(mi, 'Fix stackcopy');
menuItem_insert(pmi, 16, mi) --above add this address to the list
menuItem_onClick(mi, stackcopyfix)


createFormFromFile(getCheatEngineDir()..[[autorun\frmFixStack.frm]])